#include <stdio.h>						//for HIPS
#include <hipl_format.h>				//for HIPS
#include "ExternHIPS.h"					//for HIPS
#include <OpenGL/gl.h>					//for  OpenGL
#include <OpenGL/glu.h>					//for  OpenGL
#include <OpenGL/glext.h>				//for  OpenGL
#include <OpenGL/OpenGL.h>				//for  CoreOpenGL
#include <string.h>
#include <PrecisionTime.h>				//provides GetSecs


//typedefs
typedef enum _ScaleModeType_{
	khpsNoneSpecified,			
	khpsClampToZero,			//Scale to fit: zero in file assigned to zero screen luminance
	khpsClampToMean,			//Scale to fit: zero in file assigned to median screen luninance
	khpsFloat,					//Scale to fit: min in file assigned to zero luminance and max in file assigned to max liminance
	khpsNoScale					//Do not alter luminance values.
	} ScaleModeType;
	
typedef enum _DisplayTargetModeType_{
	khpsNoTarget,
	khpsWindowTarget,
	khpsFullscreenTarget
	} DisplayTargetModeType;
	
typedef enum _BackgroundColorModeType_{
	khpsBackgroundBlack,
	khpsBackgroundWhite,
	khpsBackgroundMidgray,
	khpsBackgroundMean,
	khpsBackgroundEdgeMean
	} BackgroundColorModeType;
	
typedef enum _TextureModeType_{
	khpsTextureRangeAndMemcpy,
	khpsTextureRangeAndNoMemcpy,		//testing only, no images
	khpsNoTextureRangeAndNoMemcpy,
	}  TextureModeType;

typedef enum _ProgressActivityType_{
	khpsProgressComplete,
	khpsLoadingFile,
	khpsMakingTextures,
	khpsFindingLuminanceMean,
	khpsFindingLuminanceEdgeMean	
	} ProgressActivityType;

typedef enum _ContextDepthModeType_{
	khps8Bits,
	khps32Bits
} ContextDepthModeType;


	
typedef struct _HipsViewerCommandFlagsType_{
	h_boolean					useCommandLine;
	Filename					fileName;
	
	h_boolean					displayNumberPresent;
	int							displayNumber;
	h_boolean					displayNamePresent;
	char						*displayName;
	h_boolean					palindromeFlag;
	h_boolean					continuousFlag;
	int							numberOfLoops;
	h_boolean					forwardFlag;
	h_boolean					reverseFlag;
	h_boolean					terminateFlag;
	h_boolean					exitOnKeyFlag;
	h_boolean					backgroundPresent;
	char						*backgroundColorName;
	h_boolean					getKeysFlag;
	int							getkeysExtraDuration;
	h_boolean					usePreviewWindowFlag;
} HipsViewerCommandFlagsType;


extern		HipsViewerCommandFlagsType  commandFlags;  //global variable used to transmit command line info received in main into the Cocoa runtime object.  Defined in main.m


//helper functions
void	FindMovieLuminanceBounds(float *movieMemory, unsigned long movieSizeFloatPixels, float *maxValue, float *minValue);
void	FindScalerAndOffsetFromPixelRangeAndScalingMode(float maxValue, float minValue, int ScaleMode, float *scaleL, float *offsetL);
void	CenterCarbonRectInRect(Rect *insideRect, Rect *outsideRect, Rect *newRect);
NSRect  CenterNSRectInNSRect(NSRect innerRect, NSRect outerRect);
void	ConvertNSRectToQDRect(NSRect nsRect, Rect *rect);
void	ConvertNSRectToCGRect(NSRect nsRect, CGRect *cgRect);
void    ConvertNSRectToGLVertices(NSRect, float *v1, float *v2, float *v3, float *v4); 
double  GetBusTicksFrequency(void);
BOOL	SetRealtimePriority(int level);
void	PackFloatColorTripletIntoInt(float r, float g, float b, GLuint *packedInt, float scaleL, float offsetL);
void	PackFloatColorMonoIntoInt(float rgb, GLuint *packedInt, float scaleL, float offsetL);
void	PackFloatColorMonoIntoByte(float rgb, GLubyte *packedByte, float scaleL, float offsetL);
